<?php
/**
 * Download Routes Handler
 * 
 * Manages download routes for digital products
 * 
 * @package HNG_Commerce
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Register download route
 */
add_action('init', function() {
    add_rewrite_rule(
        '^download/([a-zA-Z0-9]+)/?$',
        'index.php?hng_download_id=$matches[1]',
        'top'
    );
    
    add_filter('query_vars', function($vars) {
        $vars[] = 'hng_download_id';
        return $vars;
    });
}, 5);

/**
 * Handle download template redirect
 */
add_action('template_redirect', function() {
    $download_id = get_query_var('hng_download_id');
    
    if ($download_id) {
        $template = HNG_COMMERCE_PATH . 'templates/download-handler.php';
        
        if (file_exists($template)) {
            include $template;
            exit;
        }
    }
});

/**
 * Grant download access after payment confirmation
 */
add_action('hng_order_status_changed', function($order_id, $old_status, $new_status) {
    // Only grant access when order is completed or processing
    if (!in_array($new_status, ['processing', 'completed'])) {
        return;
    }
    
    $order = new HNG_Order($order_id);
    $items = $order->get_items();
    
    foreach ($items as $item) {
        $product = new HNG_Product($item['product_id']);
        
        // Check if product is downloadable
        if ($product->is_downloadable()) {
            $digital_product = new HNG_Digital_Product($item['product_id']);
            $digital_product->grant_access($order_id, $order->get_customer_email());
        }
    }
}, 10, 3);
