<?php
if (!defined('ABSPATH')) { exit; }

class HNG_Widget_Product_Grid extends HNG_Commerce_Elementor_Widget_Base {
    
    public function get_name() { 
        return 'hng_product_grid'; 
    }
    
    public function get_title() { 
        return __('Grade de Produtos', 'hng-commerce'); 
    }
    
    public function get_icon() { 
        return 'eicon-posts-grid'; 
    }
    
    public function get_categories() {
        return ['hng-commerce'];
    }

    protected function register_controls() {
                // Tï¿½tulos, descriï¿½ï¿½es e placeholders editï¿½veis
                $this->start_controls_section(
                    'labels_section',
                    [
                        'label' => __('Textos e Placeholders', 'hng-commerce'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    ]
                );
                $this->add_control('label_grid_title', [ 'label' => __('Tï¿½tulo da Grade', 'hng-commerce'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('Produtos em Destaque', 'hng-commerce') ]);
                $this->add_control('label_empty', [ 'label' => __('Mensagem Sem Produtos', 'hng-commerce'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('Nenhum produto encontrado.', 'hng-commerce') ]);
                $this->add_control('placeholder_search', [ 'label' => __('Placeholder Busca', 'hng-commerce'), 'type' => \Elementor\Controls_Manager::TEXT, 'default' => __('Buscar produtos...', 'hng-commerce') ]);
                $this->end_controls_section();

                // Variaï¿½ï¿½o de layout (grid/lista/carrossel)
                $this->start_controls_section(
                    'layout_section',
                    [
                        'label' => __('Layout', 'hng-commerce'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    ]
                );
                $this->add_control('product_grid_layout', [
                    'label' => __('Layout da Grade', 'hng-commerce'),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'grid' => __('Grid', 'hng-commerce'),
                        'list' => __('Lista', 'hng-commerce'),
                        'carousel' => __('Carrossel', 'hng-commerce'),
                    ],
                    'default' => 'grid',
                ]);
                $this->end_controls_section();
        
        // ====================
        // CONTEï¿½DO
        // ====================
        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Configuraï¿½ï¿½o', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'columns',
            [
                'label' => __('Colunas', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 6,
            ]
        );
        
        $this->add_control(
            'products_per_page',
            [
                'label' => __('Produtos por pï¿½gina', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
                'max' => 50,
            ]
        );
        
        $this->add_control(
            'orderby',
            [
                'label' => __('Ordenar por', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __('Data', 'hng-commerce'),
                    'title' => __('Tï¿½tulo', 'hng-commerce'),
                    'price' => __('Preï¿½o', 'hng-commerce'),
                    'rand' => __('Aleatï¿½rio', 'hng-commerce'),
                ],
            ]
        );
        
        $this->add_control(
            'order',
            [
                'label' => __('Ordem', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'ASC' => __('Crescente', 'hng-commerce'),
                    'DESC' => __('Decrescente', 'hng-commerce'),
                ],
            ]
        );
        
        $this->add_control(
            'show_image',
            [
                'label' => __('Mostrar Imagem', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'show_title',
            [
                'label' => __('Mostrar Tï¿½tulo', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'show_price',
            [
                'label' => __('Mostrar Preï¿½o', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'show_button',
            [
                'label' => __('Mostrar Botï¿½o', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        
        $this->add_control(
            'button_text',
            [
                'label' => __('Texto do Botï¿½o', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Comprar', 'hng-commerce'),
                'condition' => ['show_button' => 'yes'],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - CONTAINER
        // ====================
        $this->start_controls_section(
            'section_container_style',
            [
                'label' => __('Container', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_responsive_control(
            'column_gap',
            [
                'label' => __('Espaï¿½amento entre Colunas', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => ['min' => 0, 'max' => 100],
                    '%' => ['min' => 0, 'max' => 10],
                ],
                'default' => ['size' => 20, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-grid' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - CARD
        // ====================
        $this->start_controls_section(
            'section_card_style',
            [
                'label' => __('Card do Produto', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
            'card_background',
            [
                'label' => __('Background', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'card_border',
                'selector' => '{{WRAPPER}} .hng-product-card',
            ]
        );
        
        $this->add_responsive_control(
            'card_border_radius',
            [
                'label' => __('Raio da Borda', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_box_shadow',
                'selector' => '{{WRAPPER}} .hng-product-card',
            ]
        );
        
        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __('Padding', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => ['top' => 15, 'right' => 15, 'bottom' => 15, 'left' => 15, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        // Hover
        $this->add_control(
            'card_hover_heading',
            [
                'label' => __('Hover', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'card_hover_background',
            [
                'label' => __('Background (Hover)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hng-product-card:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_hover_box_shadow',
                'label' => __('Sombra (Hover)', 'hng-commerce'),
                'selector' => '{{WRAPPER}} .hng-product-card:hover',
            ]
        );
        
        $this->add_control(
            'card_hover_transition',
            [
                'label' => __('Transiï¿½ï¿½o (ms)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 300,
                'selectors' => [
                    '{{WRAPPER}} .hng-product-card' => 'transition: all {{VALUE}}ms ease;',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - IMAGEM
        // ====================
        $this->start_controls_section(
            'section_image_style',
            [
                'label' => __('Imagem', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_image' => 'yes'],
            ]
        );
        
        $this->add_responsive_control(
            'image_height',
            [
                'label' => __('Altura', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => ['min' => 100, 'max' => 600],
                    '%' => ['min' => 50, 'max' => 100],
                ],
                'default' => ['size' => 250, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-image img' => 'height: {{SIZE}}{{UNIT}}; object-fit: cover;',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => __('Raio da Borda', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - Tï¿½TULO
        // ====================
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __('Tï¿½tulo', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_title' => 'yes'],
            ]
        );
        
        $this->add_control(
            'title_color',
            [
                'label' => __('Cor', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .hng-product-title',
            ]
        );
        
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('Margem', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'default' => ['top' => 10, 'right' => 0, 'bottom' => 5, 'left' => 0, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Cor (Hover)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hng-product-title:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - PREï¿½O
        // ====================
        $this->start_controls_section(
            'section_price_style',
            [
                'label' => __('Preï¿½o', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_price' => 'yes'],
            ]
        );
        
        $this->add_control(
            'price_color',
            [
                'label' => __('Cor', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#27ae60',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-price' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'price_typography',
                'selector' => '{{WRAPPER}} .hng-product-price',
            ]
        );
        
        $this->add_responsive_control(
            'price_margin',
            [
                'label' => __('Margem', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'default' => ['top' => 5, 'right' => 0, 'bottom' => 10, 'left' => 0, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        
        // ====================
        // ESTILOS - BOTï¿½O
        // ====================
        $this->start_controls_section(
            'section_button_style',
            [
                'label' => __('Botï¿½o', 'hng-commerce'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_button' => 'yes'],
            ]
        );
        
        $this->add_control(
            'button_color',
            [
                'label' => __('Cor do Texto', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_background',
            [
                'label' => __('Background', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3498db',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .hng-product-button',
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .hng-product-button',
            ]
        );
        
        $this->add_responsive_control(
            'button_border_radius',
            [
                'label' => __('Raio da Borda', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => ['top' => 4, 'right' => 4, 'bottom' => 4, 'left' => 4, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'default' => ['top' => 10, 'right' => 20, 'bottom' => 10, 'left' => 20, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        // Hover
        $this->add_control(
            'button_hover_heading',
            [
                'label' => __('Hover', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'button_hover_color',
            [
                'label' => __('Cor do Texto (Hover)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_hover_background',
            [
                'label' => __('Background (Hover)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2980b9',
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'button_hover_transition',
            [
                'label' => __('Transiï¿½ï¿½o (ms)', 'hng-commerce'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 300,
                'selectors' => [
                    '{{WRAPPER}} .hng-product-button' => 'transition: all {{VALUE}}ms ease;',
                ],
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Buscar produtos
        $args = [
            'post_type' => 'hng_product',
            'posts_per_page' => $settings['products_per_page'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'post_status' => 'publish',
        ];
        
        $products = new WP_Query($args);
        
        if (!$products->have_posts()) {
            echo '<p>' . esc_html__('Nenhum produto encontrado.', 'hng-commerce') . '</p>';
            return;
        }
        
        $columns = absint($settings['columns']);
        ?>
        
        <div class="hng-product-grid" style="display: grid; grid-template-columns: repeat(<?php echo esc_attr($columns); ?>, 1fr); width: 100%;">
            <?php while ($products->have_posts()) : $products->the_post(); 
                $product = new HNG_Product(get_the_ID());
                $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                if (!$thumbnail) {
                    $thumbnail = HNG_COMMERCE_URL . 'assets/images/placeholder.svg';
                }
            ?>
                <div class="hng-product-card">
                    <?php if ($settings['show_image'] === 'yes') : ?>
                        <div class="hng-product-image">
                            <a href="<?php echo esc_url(get_permalink()); ?>">
                                <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" style="width: 100%; display: block;">
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_title'] === 'yes') : ?>
                        <h3 class="hng-product-title">
                            <a href="<?php echo esc_url(get_permalink()); ?>" style="text-decoration: none; color: inherit;">
                                <?php echo esc_html(get_the_title()); ?>
                            </a>
                        </h3>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_price'] === 'yes') : ?>
                        <div class="hng-product-price">
                            <?php echo esc_html(hng_price($product->get_price())); ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($settings['show_button'] === 'yes') : ?>
                        <button class="hng-product-button" data-product-id="<?php echo esc_attr(get_the_ID()); ?>" style="width: 100%; border: none; cursor: pointer; text-align: center; display: block;">
                            <?php echo esc_html($settings['button_text']); ?>
                        </button>
                    <?php endif; ?>
                </div>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>
        
        <script>
        jQuery(document).ready(function($) {
            $('.hng-product-button').on('click', function() {
                var productId = $(this).data('product-id');
                // Adicionar ao carrinho via AJAX
                $.post(ajaxurl, {
                    action: 'hng_add_to_cart',
                    product_id: productId,
                    quantity: 1
                }, function(response) {
                    if (response.success) {
                        alert('Produto adicionado ao carrinho!');
                    }
                });
            });
        });
        </script>
        <?php
    }
}
