<?php

/**

 * Script para criar a página "Seja Nosso Cliente"

 * Execute este script uma vez após a atualização do plugin

 * Acesse: /wp-content/plugins/hng-commerce/setup-client-registration-page.php

 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Load WordPress

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-load.php';



// Check permissions

if (!current_user_can('manage_options')) {

    wp_die('Acesso negado. Faça login como administrador.');

}



// Page data

$page_slug = 'seja-nosso-cliente';

$page_title = 'Seja Nosso Cliente';

$page_template = 'page-seja-nosso-cliente.php';



// Check if page exists

$existing = get_page_by_path($page_slug);



if ($existing) {

    // Update template if needed

    $current_template = get_post_meta($existing->ID, '_wp_page_template', true);

    if (empty($current_template) || $current_template === 'default') {

        update_post_meta($existing->ID, '_wp_page_template', $page_template);

        echo '<p style="color: green;">✓ Template da página atualizado!</p>';

    } else {

        echo '<p style="color: blue;">ℹ Página já existe (ID: ' . intval($existing->ID) . ').</p>';

    }

    update_option('hng_commerce_client-registration_page_id', $existing->ID);

} else {

    // Create page

    $page_id = wp_insert_post([

        'post_title' => $page_title,

        'post_content' => '',

        'post_name' => $page_slug,

        'post_status' => 'publish',

        'post_type' => 'page',

        'comment_status' => 'closed',

        'ping_status' => 'closed'

    ]);

    

    if ($page_id && !is_wp_error($page_id)) {

        update_post_meta($page_id, '_wp_page_template', $page_template);

        update_option('hng_commerce_client-registration_page_id', $page_id);

        echo '<p style="color: green;">✓ Página criada com sucesso! (ID: ' . intval($page_id) . ')</p>';

    } else {

        echo '<p style="color: red;">✗ Erro ao criar página.</p>';

    }

}



// Create hng_customer role if not exists

if (!get_role('hng_customer')) {

    add_role('hng_customer', 'Cliente HNG', [

        'read' => true,

        'edit_posts' => false,

        'delete_posts' => false,

    ]);

    echo '<p style="color: green;">✓ Role "hng_customer" criada!</p>';

} else {

    echo '<p style="color: blue;">ℹ Role "hng_customer" já existe.</p>';

}



echo '<hr>';

echo '<p><a href="' . esc_url(home_url('/seja-nosso-cliente/')) . '" target="_blank">→ Ver página de cadastro</a></p>';

echo '<p><a href="' . esc_url(admin_url('admin.php?page=hng-customers')) . '">→ Ver clientes no admin</a></p>';

echo '<p style="color: orange; margin-top: 20px;"><strong>Importante:</strong> Delete este arquivo após a execução por segurança.</p>';

