<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<!-- Template: Pagamento com Cartão Mercado Pago -->
<div class="hng-payment-method-content" id="payment-mercadopago-card" style="display: none;">
    <div class="hng-mercadopago-card-form">
        <h4>Pagamento com Cartão de Crédito</h4>
        <p class="hng-secure-badge">Pagamento 100% seguro via Mercado Pago</p>
        
        <!-- Card Form -->
        <form id="hng-mercadopago-form">
            <!-- Número do Cartão -->
            <div class="hng-form-group">
                <label for="mp-card-number">Número do Cartão <span class="required">*</span></label>
                <div class="hng-card-input-wrapper">
                    <input 
                        type="text" 
                        id="mp-card-number" 
                        data-checkout="cardNumber"
                        placeholder="0000 0000 0000 0000"
                        maxlength="19"
                        required
                    >
                    <div id="mp-card-brand" class="hng-card-brand"></div>
                </div>
                <small class="hng-field-error" id="error-card-number"></small>
            </div>
            
            <!-- Nome no Cartão -->
            <div class="hng-form-group">
                <label for="mp-card-holder-name">Nome Impresso no Cartão <span class="required">*</span></label>
                <input 
                    type="text" 
                    id="mp-card-holder-name" 
                    data-checkout="cardholderName"
                    placeholder="Como está impresso no cartão"
                    required
                >
                <small class="hng-field-error" id="error-card-holder"></small>
            </div>
            
            <!-- Validade e CVV -->
            <div class="hng-form-row">
                <div class="hng-form-group hng-col-6">
                    <label for="mp-card-expiry">Validade <span class="required">*</span></label>
                    <input 
                        type="text" 
                        id="mp-card-expiry" 
                        placeholder="MM/AA"
                        maxlength="5"
                        required
                    >
                    <input type="hidden" id="mp-card-expiry-month" data-checkout="cardExpirationMonth">
                    <input type="hidden" id="mp-card-expiry-year" data-checkout="cardExpirationYear">
                    <small class="hng-field-error" id="error-expiry"></small>
                </div>
                
                <div class="hng-form-group hng-col-6">
                    <label for="mp-card-cvv">CVV <span class="required">*</span></label>
                    <input 
                        type="text" 
                        id="mp-card-cvv" 
                        data-checkout="securityCode"
                        placeholder="000"
                        maxlength="4"
                        required
                    >
                    <small class="hng-field-error" id="error-cvv"></small>
                </div>
            </div>
            
            <!-- CPF do Titular -->
            <div class="hng-form-group">
                <label for="mp-card-holder-cpf">CPF do Titular <span class="required">*</span></label>
                <input 
                    type="text" 
                    id="mp-card-holder-cpf" 
                    data-checkout="docNumber"
                    placeholder="000.000.000-00"
                    maxlength="14"
                    required
                >
                <small class="hng-field-error" id="error-cpf"></small>
            </div>
            
            <!-- Parcelamento -->
            <div class="hng-form-group">
                <label for="mp-installments">Parcelamento <span class="required">*</span></label>
                <select id="mp-installments" data-checkout="installments" required>
                    <option value="">Carregando opções...</option>
                </select>
                <small class="hng-installments-info"></small>
            </div>
            
            <input type="hidden" id="mp-payment-method-id" data-checkout="paymentMethodId">
            <input type="hidden" id="mp-card-token" name="card_token">
        </form>
        
        <!-- Bandeiras Aceitas -->
        <div class="hng-accepted-cards">
            <small>Aceitamos:</small>
            <div class="hng-card-brands">
                <img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/images/cards/visa.svg' ); ?>" alt="Visa" title="Visa">
                <img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/images/cards/mastercard.svg' ); ?>" alt="Mastercard" title="Mastercard">
                <img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/images/cards/elo.svg' ); ?>" alt="Elo" title="Elo">
                <img src="<?php echo esc_url( plugin_dir_url( __FILE__ ) . '../assets/images/cards/amex.svg' ); ?>" alt="American Express" title="American Express">
            </div>
        </div>
    </div>
</div>

<style>
.hng-mercadopago-card-form {
    background: white;
    padding: 25px;
    border-radius: 8px;
    border: 1px solid #e0e0e0;
}

.hng-mercadopago-card-form h4 {
    margin: 0 0 10px 0;
    font-size: 18px;
    color: #333;
}

.hng-secure-badge {
    display: inline-block;
    background: #e8f5e9;
    color: #2e7d32;
    padding: 6px 12px;
    border-radius: 4px;
    font-size: 13px;
    margin-bottom: 20px;
}

.hng-form-group {
    margin-bottom: 20px;
}

.hng-form-group label {
    display: block;
    font-size: 14px;
    font-weight: 600;
    color: #333;
    margin-bottom: 8px;
}

.hng-form-group .required {
    color: #e74c3c;
}

.hng-card-input-wrapper {
    position: relative;
}

.hng-card-input-wrapper input {
    padding-right: 50px;
}

.hng-card-brand {
    position: absolute;
    right: 10px;
    top: 50%;
    transform: translateY(-50%);
    width: 35px;
    height: 24px;
    background-size: contain;
    background-repeat: no-repeat;
    background-position: center;
}

.hng-form-group input,
.hng-form-group select {
    width: 100%;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 14px;
    transition: all 0.3s;
}

.hng-form-group input:focus,
.hng-form-group select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.hng-form-group input.error {
    border-color: #e74c3c;
}

.hng-field-error {
    display: block;
    color: #e74c3c;
    font-size: 12px;
    margin-top: 5px;
    min-height: 18px;
}

.hng-form-row {
    display: flex;
    gap: 15px;
}

.hng-col-6 {
    flex: 1;
}

.hng-installments-info {
    display: block;
    color: #666;
    font-size: 12px;
    margin-top: 5px;
}

.hng-accepted-cards {
    margin-top: 25px;
    padding-top: 20px;
    border-top: 1px solid #e0e0e0;
}

.hng-accepted-cards small {
    display: block;
    color: #999;
    font-size: 12px;
    margin-bottom: 10px;
}

.hng-card-brands {
    display: flex;
    gap: 10px;
    align-items: center;
}

.hng-card-brands img {
    height: 24px;
    width: auto;
    opacity: 0.7;
    transition: opacity 0.3s;
}

.hng-card-brands img:hover {
    opacity: 1;
}

@media (max-width: 768px) {
    .hng-form-row {
        flex-direction: column;
    }
}
</style>

<?php
// Mercado Pago SDK should be enqueued via wp_enqueue_script in gateway class or checkout page
// Example: wp_enqueue_script('mercadopago-sdk', 'https://sdk.mercadopago.com/js/v2', [], null, true);
// For now, adding note that this template expects the SDK to already be loaded
?>
<script>
jQuery(document).ready(function($) {
    // Inicializar Mercado Pago SDK
    const mp_public_key = '<?php echo esc_js(get_option("hng_mercadopago_public_key", "")); ?>';
    
    if (!mp_public_key) {
        console.error('Mercado Pago: Chave pública não configurada');
        return;
    }
    
    const mp = new MercadoPago(mp_public_key);
    let currentPaymentMethod = null;
    
    // Máscara de Cartão
    $('#mp-card-number').on('input', function() {
        let value = $(this).val().replace(/\s/g, '');
        let formatted = value.match(/.{1,4}/g)?.join(' ') || value;
        $(this).val(formatted);
        
        // Detectar bandeira
        if (value.length >= 6) {
            detectCardBrand(value);
        }
    });
    
    // Máscara de Validade
    $('#mp-card-expiry').on('input', function() {
        let value = $(this).val().replace(/\D/g, '');
        if (value.length >= 2) {
            value = value.substring(0, 2) + '/' + value.substring(2, 4);
        }
        $(this).val(value);
        
        // Atualizar campos hidden
        const parts = value.split('/');
        if (parts.length === 2) {
            $('#mp-card-expiry-month').val(parts[0]);
            $('#mp-card-expiry-year').val('20' + parts[1]);
        }
    });
    
    // Máscara de CVV
    $('#mp-card-cvv').on('input', function() {
        $(this).val($(this).val().replace(/\D/g, ''));
    });
    
    // Máscara de CPF
    $('#mp-card-holder-cpf').on('input', function() {
        let value = $(this).val().replace(/\D/g, '');
        value = value.replace(/(\d{3})(\d)/, '$1.$2');
        value = value.replace(/(\d{3})(\d)/, '$1.$2');
        value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
        $(this).val(value);
    });
    
    // Detectar bandeira do cartão
    function detectCardBrand(cardNumber) {
        const bin = cardNumber.substring(0, 6);
        
        $.ajax({
            url: 'https://api.mercadopago.com/v1/payment_methods',
            method: 'GET',
            data: {
                public_key: mp_public_key,
                bin: bin
            },
            success: function(response) {
                if (response.results && response.results.length > 0) {
                    const paymentMethod = response.results[0];
                    currentPaymentMethod = paymentMethod;
                    
                    // Exibir logo da bandeira
                    $('#mp-card-brand').css('background-image', 'url(' + paymentMethod.secure_thumbnail + ')');
                    $('#mp-payment-method-id').val(paymentMethod.id);
                    
                    // Carregar opções de parcelamento
                    loadInstallments(paymentMethod.id);
                }
            }
        });
    }
    
    // Carregar opções de parcelamento
    function loadInstallments(paymentMethodId) {
        const amount = parseFloat($('#checkout-total-amount').data('amount') || 0);
        
        if (amount <= 0) return;
        
        $.ajax({
            url: 'https://api.mercadopago.com/v1/payment_methods/installments',
            method: 'GET',
            data: {
                public_key: mp_public_key,
                amount: amount,
                payment_method_id: paymentMethodId
            },
            success: function(response) {
                if (response[0] && response[0].payer_costs) {
                    const $select = $('#mp-installments');
                    $select.empty();
                    
                    response[0].payer_costs.forEach(function(option) {
                        const label = option.recommended_message || 
                                    option.installments + 'x de R$ ' + 
                                    (option.installment_amount).toFixed(2).replace('.', ',');
                        
                        $select.append(
                            $('<option>', {
                                value: option.installments,
                                text: label,
                                'data-rate': option.installment_rate
                            })
                        );
                    });
                    
                    // Selecionar primeira opção
                    $select.val(response[0].payer_costs[0].installments);
                }
            }
        });
    }
    
    // Validar e criar token ao confirmar pedido
    $('#place-order-btn').on('click', function(e) {
        if ($('input[name="payment_method"]:checked').val() !== 'mercadopago') {
            return;
        }
        
        e.preventDefault();
        
        // Limpar erros
        $('.hng-field-error').text('');
        $('.error').removeClass('error');
        
        // Validar campos
        let hasError = false;
        
        const cardNumber = $('#mp-card-number').val().replace(/\s/g, '');
        if (cardNumber.length < 13) {
            $('#error-card-number').text('Número do cartão inválido');
            $('#mp-card-number').addClass('error');
            hasError = true;
        }
        
        const cardHolder = $('#mp-card-holder-name').val();
        if (cardHolder.length < 3) {
            $('#error-card-holder').text('Nome do titular obrigatório');
            $('#mp-card-holder-name').addClass('error');
            hasError = true;
        }
        
        const expiry = $('#mp-card-expiry').val();
        if (!/^\d{2}\/\d{2}$/.test(expiry)) {
            $('#error-expiry').text('Validade inválida');
            $('#mp-card-expiry').addClass('error');
            hasError = true;
        }
        
        const cvv = $('#mp-card-cvv').val();
        if (cvv.length < 3) {
            $('#error-cvv').text('CVV inválido');
            $('#mp-card-cvv').addClass('error');
            hasError = true;
        }
        
        const cpf = $('#mp-card-holder-cpf').val().replace(/\D/g, '');
        if (cpf.length !== 11) {
            $('#error-cpf').text('CPF inválido');
            $('#mp-card-holder-cpf').addClass('error');
            hasError = true;
        }
        
        if (hasError) {
            return false;
        }
        
        // Criar token do cartão
        $('#place-order-btn').prop('disabled', true).text('Processando...');
        
        const form = document.getElementById('hng-mercadopago-form');
        mp.createCardToken(form).then(function(result) {
            if (result.error) {
                alert('Erro ao processar cartão: ' + result.error.message);
                $('#place-order-btn').prop('disabled', false).text('Finalizar Pedido');
                return;
            }
            
            // Salvar token
            $('#mp-card-token').val(result.id);
            
            // Submeter checkout
            submitCheckout();
            
        }).catch(function(error) {
            console.error('Erro Mercado Pago:', error);
            alert('Erro ao processar pagamento. Tente novamente.');
            $('#place-order-btn').prop('disabled', false).text('Finalizar Pedido');
        });
    });
});
</script>
